--[[
Copyright (c) 2017 Vexlio, LLC. All rights reserved. 

This file is licensed under the MIT License:

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

-- Plugin info
VexlioPlugin = {
    name = "UI components example",
    author = "Vexlio",
    description = "Demonstrates available UI components for Vexlio plugins.",
    id = "com.vexlio.ui-components-example"
}

-- Define the function, called by Vexlio, to create the plugin's UI.
function pluginUI()
    local win = Vexlio:window()
    local r = win:row()
    win:label("Buttons:", r, 0, 3)
    win:button("Button 1", nil, r, 3, 4)
    win:button("Button 2", nil, r, 8, 4)

    win:row(20)
    r = win:row()
    win:label("Check boxes:", r, 0, 3)
    win:checkbox("Box 1", nil, r, 3, 3)
    win:checkbox("Box 2", nil, r, 6, 3).checked = true
    win:checkbox("Box 3", nil, r, 9, 3)

    win:row(20)
    local sliderLabel = win:label("Sliders (value: )", win:row(), 0, 4)
    win:row(5)
    r = win:row()
    win:label("-10", r, 0, 1)
    win:slider(-10, 10, 1,
               function (v)
                   sliderLabel.label = "Sliders (value: " .. v .. ")"
               end, r, 1, 10).value = 4
    win:label("10", r, 11, 1)

    win:row(20)
    r = win:row()
    win:label("Radio buttons:", r, 0, 3)
    local rg = win:radioGroup(false, nil, r, 3, 9)
    rg:option("Choice 1")
    rg:option("Choice 2")
    rg:option("Choice 3")
    rg.selectedOption = 1

    win:row(20)
    r = win:row()
    win:label("Vertical radio buttons:  ", r, 0, 4)
    local rg = win:radioGroup(true, nil, r, 5, 9)
    rg:option("Choice 1")
    rg:option("Choice 2")
    rg:option("Choice 3")
    rg.selectedOption = 1
    
    win:row(20)
    r = win:row()
    win:label("Text box:", r, 0, 2)
    win:textbox(r, 2, 7).text = "Enter a value..."
    win:button("Submit", nil, r, 10, 2)
end
