#pragma once

#include <stdio.h>
#include <tchar.h>
#include <stdlib.h>
#include <string.h>
#include <vector>
#include <fstream>
#include <iostream>  //std::cerr  std::cout
#include <time.h>
#include <math.h>

#define GLEW_STATIC
#include "GL/glew.h"
#ifdef _WIN32
#include "GL/wglew.h" // For wglSwapInterval
#endif

#define GLM_FORCE_RADIANS
#include "glm/glm.hpp"
#include "glm/gtc/epsilon.hpp"
#include "glm/gtc/type_ptr.hpp"
#include "glm/gtc/matrix_transform.hpp"
#include "glm/gtx/transform.hpp"
#include "glm/gtx/quaternion.hpp"
#include "glm/gtx/compatibility.hpp"
#include "glm/ext.hpp"
#include "glm/gtx/vector_angle.hpp"

#define BFG_RS_NONE  0x0      // Blend flags
#define BFG_RS_ALPHA 0x1
#define BFG_RS_RGB   0x2
#define BFG_RS_RGBA  0x4

#define BFG_MAXSTRING 255     // Maximum string length

#define WIDTH_DATA_OFFSET  20 // Offset to width data with BFF file
#define MAP_DATA_OFFSET   276 // Offset to texture image data with BFF file

// This definition is missing from some GL libs
#ifndef GL_CLAMP_TO_EDGE 
#define GL_CLAMP_TO_EDGE 0x812F 
#endif

extern int iScreenWidth;
extern int iScreenHeight;
extern HINSTANCE	hInstance;		// Holds The Instance Of The Application

typedef struct
{
	unsigned char ID1, ID2;
	unsigned char BPP;
	int ImageWidth, ImageHeight, CellWidth, CellHeight;
	unsigned char StartPoint;
}FontFileHeader;


using namespace glm;

namespace Textfont
{
	using namespace std;

	class Ifont
	{
		public:

			static bool initText2D(const std::string& fname);
			static void printText2D(const char * text, int x, int y, int Size = 0);
			static void cleanupText2D();
			static void SetColor(float, float, float, float alpha = 1.f);
			static int  GetWidth(char *Text);

		private:
			static GLuint LoadShader(GLenum shaderType, const GLint shaderFile);
			static GLuint CreateShaderProgram(std::vector<GLuint> shaders);

	};
}