#pragma once
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <math.h>

int Np, Nv;

// points, normals and poligon coordinates
//*********************************************
struct Poligon
{
    int nv;
    int* ip;
};

Poligon *Poli;

struct Coordinate
{
    float x, y, z;
};

Coordinate *Verti;

Coordinate *Norm_Pv;
Coordinate *NPp;
//********************************************

float D_unit;  //unit distance
float *MaxVertex;
float *MinVertex;
float *Centroide;

//mesh data calculation
void Bound_Box()
{
    MaxVertex = new float[3];
    MaxVertex[0] = MaxVertex[1] = MaxVertex[2] = 0.f;
    MinVertex = new float[3];
    MinVertex[0] = MinVertex[1] = MinVertex[2] = 0.f;
    Centroide = new float[3];
    Centroide[0] = Centroide[1] = Centroide[2] = D_unit = 0.f;

	if(((MaxVertex[1] == 0) && (MinVertex[1] == 0)))
	{
		GLfloat auxMx = 0.0;
		GLfloat auxMy = 0.0;
		GLfloat auxMz = 0.0;
		GLfloat auxmx = 0.0;
		GLfloat auxmy = 0.0;
		GLfloat auxmz = 0.0;

				auxMx = Verti[0].x;
				auxMy = Verti[0].y;
				auxMz = Verti[0].z;
				auxmx = Verti[0].x;
				auxmy = Verti[0].y;
				auxmz = Verti[0].z;

		for(int i=0; i< Nv;i++)
		{
				if(auxMx < Verti[i].x)
				auxMx = Verti[i].x;
				if(auxMy < Verti[i].y)
					auxMy = Verti[i].y;
				if(auxMz < Verti[i].z)
					auxMz = Verti[i].z;
				if(auxmx > Verti[i].x)
				auxmx = Verti[i].x;
				if(auxmy > Verti[i].y)
					auxmy = Verti[i].y;
				if(auxmz > Verti[i].z)
					auxmz = Verti[i].z;

			Centroide[0] += Verti[i].x;
			Centroide[1] += Verti[i].y;
			Centroide[2] += Verti[i].z;
		}

		MaxVertex[0] = auxMx;
		MaxVertex[1] = auxMy;
		MaxVertex[2] = auxMz;
		MinVertex[0] = auxmx;
		MinVertex[1] = auxmy;
		MinVertex[2] = auxmz;


		Centroide[0] /= Nv;
		Centroide[1] /= Nv;
		Centroide[2] /= Nv;
/*
		Centroide[0] = (GLfloat)(MaxVertex[0] + MinVertex[0]) / (GLfloat)2.0;
		Centroide[1] = (GLfloat)(MaxVertex[1] + MinVertex[1]) / (GLfloat)2.0;
		Centroide[2] = (GLfloat)(MaxVertex[2] + MinVertex[2]) / (GLfloat)2.0;
*/

		for(int i=0; i< Nv;i++)
		{
			Verti[i].x -= Centroide[0];
			Verti[i].y -= Centroide[1];
			Verti[i].z += -Centroide[2];
		}

		auxMx = 0.0;
		for(int i=0; i< Nv;i++)
		{
				auxMx = sqrt(powf((Centroide[0] - Verti[i].x), 2.f) + powf((Centroide[1] - Verti[i].y), 2.f) + powf((Centroide[2] - Verti[i].z), 2.f));
				if(D_unit < auxMx)
					D_unit = auxMx;
		}

//		D_unit = sqrt(powf((MaxVertex[0] - MinVertex[0]), 2.f) + powf((MaxVertex[1] - MinVertex[1]), 2.f) + powf((MaxVertex[2] - MinVertex[2]), 2.f));
		D_unit = (GLfloat)1.f/D_unit;

		MaxVertex[0] -= Centroide[0];
		MaxVertex[1] -= Centroide[1];
		MaxVertex[2] += -Centroide[2];

		MinVertex[0] -= Centroide[0];
		MinVertex[1] -= Centroide[1];
		MinVertex[2] += -Centroide[2];
	}
}


void Set_Normals()
{

    //*********************************Norm

    NPp = new Coordinate[Np];

    for (int i = 0; i<Np; i++)
    {
        float nvect[3];
        float nvect1[3];
        float nvect2[3];

        nvect1[0] = ((Verti[Poli[i].ip[1]].x) - (Verti[Poli[i].ip[0]].x));
        nvect1[1] = ((Verti[Poli[i].ip[1]].y) - (Verti[Poli[i].ip[0]].y));
        nvect1[2] = ((Verti[Poli[i].ip[1]].z) - (Verti[Poli[i].ip[0]].z));

        nvect2[0] = ((Verti[Poli[i].ip[2]].x) - (Verti[Poli[i].ip[0]].x));
        nvect2[1] = ((Verti[Poli[i].ip[2]].y) - (Verti[Poli[i].ip[0]].y));
        nvect2[2] = ((Verti[Poli[i].ip[2]].z) - (Verti[Poli[i].ip[0]].z));

        nvect[0] = ((nvect1[1] * nvect2[2]) - (nvect1[2] * nvect2[1]));
        nvect[1] = -((nvect1[0] * nvect2[2]) - (nvect1[2] * nvect2[0]));
        nvect[2] = ((nvect1[0] * nvect2[1]) - (nvect1[1] * nvect2[0]));



        NPp[i].x = nvect[0];
        NPp[i].y = nvect[1];
        NPp[i].z = nvect[2];
    }


    for (int i = 0; i<Np; i++)
        for (int j = 0; j<Poli[i].nv; j++)
        {
            Norm_Pv[Poli[i].ip[j]].x += NPp[i].x;
            Norm_Pv[Poli[i].ip[j]].y += NPp[i].y;
            Norm_Pv[Poli[i].ip[j]].z += NPp[i].z;
        }

    for (int i = 0; i<Nv; i++)
    {
        float nvect = sqrt((Norm_Pv[i].x * Norm_Pv[i].x) + (Norm_Pv[i].y * Norm_Pv[i].y) + (Norm_Pv[i].z * Norm_Pv[i].z));
        nvect = (float)1.0 / nvect;
        Norm_Pv[i].x *= nvect;
        Norm_Pv[i].y *= nvect;
        Norm_Pv[i].z *= nvect;
    }

    //*********************************Norm

}

void delete_points()
{
    delete[Nv] Verti;


    Verti = NULL;

    for (int k = 0; k<Np; k++)
        delete[Poli[k].nv] Poli[k].ip;

    delete[Np] Poli;
    Poli = NULL;

    delete[Nv] Norm_Pv;
    Norm_Pv = NULL;

    delete[Np] NPp;
    NPp = NULL;
}

// helper function
void readstr(FILE *f, char *string)
{
    do
    {
        fgets(string, 255, f);
    } while ((string[0] == '/') || (string[0] == '\n'));
    return;
}

//open mesh from a file on disk (only .off files)
bool Serialize_Off(char *filename, bool zeroindex = false)
{
    float x, y, z, u, t;
    FILE *filein;
    errno_t err;
    char oneline[255];
    if ((err = fopen_s(&filein, filename, "rt")) != 0)   // File To Load Off Data From
        return(false);

    readstr(filein, oneline);          // line 1
    readstr(filein, oneline);          // line 2

    sscanf_s(oneline, "%d %d ", &Nv, &Np);
    Verti = new Coordinate[Nv];
    Poli = new Poligon[Np];
    Norm_Pv = new Coordinate[Nv];
    memset(Norm_Pv, 0, Nv * sizeof(Coordinate));

    for (int loop = 0; loop < Nv; loop++)
    {
        readstr(filein, oneline);
        sscanf_s(oneline, "%f %f %f", &x, &y, &z);
        Verti[loop].x = x;
        Verti[loop].y = y;
        Verti[loop].z = z;
    }

    for (int loop = 0; loop < Np; loop++)
    {
        readstr(filein, oneline);
        sscanf_s(oneline, "%f %f %f %f", &x, &y, &z, &u);
        Poli[loop].nv = (int)x;
        if (Poli[loop].nv < 4) {
            Poli[loop].ip = new int[Poli[loop].nv];
            Poli[loop].ip[0] = (int)y;
            Poli[loop].ip[1] = (int)z;
            Poli[loop].ip[2] = (int)u;
        }
        else {
            sscanf_s(oneline, "%f %f %f %f %f", &x, &y, &z, &u, &t);
            Poli[loop].ip = new int[Poli[loop].nv];
            Poli[loop].ip[0] = (int)y;
            Poli[loop].ip[1] = (int)z;
            Poli[loop].ip[2] = (int)u;
            Poli[loop].ip[3] = (int)t;
        }
    }

    fclose(filein);

    if (zeroindex)
        for (int i = 0; i < Np; i++)
        {
            Poli[i].ip[0]--;
            Poli[i].ip[1]--;
            Poli[i].ip[2]--;
        }

    Bound_Box();
    Set_Normals();

    return(true);
}

//open mesh from a resource
bool Resource_Off(std::string fileoff, bool zeroindex = false)
{
	float x, y, z, u, t;

	std::stringstream data_stream(fileoff);
	std::string line;
	std::getline(data_stream, line);   // line 1
	std::getline(data_stream, line);   // line 2

	GLchar* oneline = (GLchar*)line.c_str();


	sscanf_s(oneline, "%d %d ", &Nv, &Np);
	Verti = new Coordinate[Nv];
	Poli = new Poligon[Np];
	Norm_Pv = new Coordinate[Nv];
	memset(Norm_Pv, 0, Nv * sizeof(Coordinate));

	for (int loop = 0; loop < Nv; loop++)
	{
		std::getline(data_stream, line);
		GLchar* oneline = (GLchar*)line.c_str();

		sscanf_s(oneline, "%f %f %f", &x, &y, &z);
		Verti[loop].x = x;
		Verti[loop].y = y;
		Verti[loop].z = z;
	}

	for (int loop = 0; loop < Np; loop++)
	{
		std::getline(data_stream, line);
		GLchar* oneline = (GLchar*)line.c_str();

		sscanf_s(oneline, "%f %f %f %f", &x, &y, &z, &u);
		Poli[loop].nv = (int)x;
		if (Poli[loop].nv < 4) {
			Poli[loop].ip = new int[Poli[loop].nv];
			Poli[loop].ip[0] = (int)y;
			Poli[loop].ip[1] = (int)z;
			Poli[loop].ip[2] = (int)u;
		}
		else {
			sscanf_s(oneline, "%f %f %f %f %f", &x, &y, &z, &u, &t);
			Poli[loop].ip = new int[Poli[loop].nv];
			Poli[loop].ip[0] = (int)y;
			Poli[loop].ip[1] = (int)z;
			Poli[loop].ip[2] = (int)u;
			Poli[loop].ip[3] = (int)t;
		}
	}

	//	fclose(fileoff);

	if (zeroindex)
		for (int i = 0; i < Np; i++)
		{
			Poli[i].ip[0]--;
			Poli[i].ip[1]--;
			Poli[i].ip[2]--;
		}

	Bound_Box();
	Set_Normals();

	return(true);
}