#version 330 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec2 vertexPosition_screenspace;
layout(location = 1) in vec2 vertexUV;

// Output data ; will be interpolated for each fragment.
out vec2 UV;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main(){

	mat4 modelView = view * model;
	gl_Position = projection * modelView * vec4(vertexPosition_screenspace, 0.f, 1.0f);
	
	// UV of the vertex. No special space for this one.
	UV = vertexUV;
}

