#version 330 core

layout (location = 0) in vec3 inPosition;
layout (location = 1) in vec3 inNormal;
layout (location = 2) in vec2 inTex;


out vec2 outTex;
out vec3 outNormal;
out vec4 outPosition;


uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;


// To know what each 'if' does, read the enum of the beginning of the main program
void main()
{
        mat4 modelView = view * model;
        gl_Position = projection * modelView * vec4(inPosition, 1.0f);

        // Position of the vertex, in worldspace : M * position
        outPosition = modelView * vec4(inPosition, 1.0);
        // UV of the vertex. No special space for this one.
        outTex = inTex;
            outNormal = inNormal;
}